/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.fru.config;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.service.config.DirParseUtils;
import com.ibm.hwmca.fw.service.config.XMLMapParser;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.EnclosureConfigEntry;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfigParser;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruGuiInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class FruConfig {
    private static final String TRACE_MASKT = "XRVFFCGT";
    private static final String TRACE_MASKF = "XRVFFCGF";
    private static final String TRACE_MASKD = "XRVFFCGD";
    private String systemType = null;
    private String systemModel = null;
    private Map completeFruTable = null;
    private Map fruInfoByEnclosure = null;
    private static Map typeModelMapCache = new HashMap();
    private static final int INIT_SIZE = 100;
    private static boolean testmode = false;

    public static void main(String[] args) {
        testmode = true;
        try {
            FruConfig fc = new FruConfig("9406", "570");
            LocalizableText[] out = fc.queryLocalizableDescriptionsByLocation(new String[]{"U7311.D11.xxxxxxx"}, null);
            Trace.trace(TRACE_MASKT, "------------->>>>" + (out == null ? "null" : out[0].toString()));
        }
        catch (Exception e) {
            System.out.println("Exception caught parsing Fru file in 9406/570");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getFruMap(String machineType, String machineModel) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        String basePath = testmode ? System.getProperty("CONSOLE_PATH") + "/data/managedsystem/fru/" : BaseFileControl.getFilePath("fruconfig");
        File typeDir = new File(basePath + machineType);
        File modelDir = new File(basePath + "/" + machineType + "/" + machineModel);
        Map returnMap = null;
        Map map = typeModelMapCache;
        synchronized (map) {
            String hashKey = typeDir.toString() + "||" + modelDir.toString();
            if (typeModelMapCache.containsKey(hashKey)) {
                returnMap = (Map)typeModelMapCache.get(hashKey);
            } else {
                returnMap = DirParseUtils.parseSubDirOverride((XMLMapParser)new FruConfigParser(), typeDir, modelDir);
                typeModelMapCache.put(hashKey, returnMap);
            }
        }
        return returnMap;
    }

    public FruConfig(String systemType, String systemModel) {
        this.systemType = systemType;
        this.systemModel = systemModel;
    }

    public Map queryEnclosureFruInfo(String enclosureType, String enclosureModel) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        return this.queryEnclosureFruInfo("U" + enclosureType + "." + (enclosureModel == null ? "___" : enclosureModel) + "._______");
    }

    public Map queryEnclosureFruInfo(String enclosureMTMS) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        Trace.trace(TRACE_MASKT, "-> FruConfig.queryEnclosureFruInfo for enclosure MTMS[" + enclosureMTMS + "]");
        if (this.fruInfoByEnclosure == null) {
            this.fruInfoByEnclosure = new HashMap();
        }
        if (!this.fruInfoByEnclosure.containsKey(enclosureMTMS)) {
            Map locations;
            String testKey;
            EnclosureConfigEntry ece;
            if (this.completeFruTable == null) {
                this.completeFruTable = FruConfig.getFruMap(this.systemType, this.systemModel);
            }
            if ((ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey = FruConfig.makeTypeModelEnclosureKey(enclosureMTMS))) == null) {
                Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo MTM key[" + testKey + "] not found in completeFruTable");
                testKey = FruConfig.makeFeatureCodeEnclosureKey(enclosureMTMS);
                ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey);
                if (ece == null) {
                    Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo feature code key[" + testKey + "] not found in completeFruTable");
                    Trace.trace(TRACE_MASKT, "<-! FruConfig.queryEnclosureFruInfo enclosure for type/model[" + enclosureMTMS + "] is not configured for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                    throw new HException("enclosure for type/model[" + enclosureMTMS + "] is not configured for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                }
            } else {
                Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo EnclosureConfigEntry defined in completeFruTable for key[" + testKey + "]");
            }
            if ((locations = ece.getLocations()) != null) {
                Collection fruConfigArrayEntries = locations.values();
                HashMap returnMap = new HashMap();
                Iterator it = fruConfigArrayEntries.iterator();
                while (it.hasNext()) {
                    Object[] oa = (Object[])it.next();
                    for (int aii = 0; aii < oa.length; ++aii) {
                        ArrayList<FruGuiInfo> flist;
                        if (!(oa[aii] instanceof FruGuiInfo)) continue;
                        FruGuiInfo fgi = (FruGuiInfo)oa[aii];
                        String fdesc = fgi.getDesc();
                        if (!returnMap.containsKey(fdesc)) {
                            flist = new ArrayList<FruGuiInfo>(oa.length);
                            returnMap.put(fdesc, flist);
                        } else {
                            flist = (ArrayList<FruGuiInfo>)returnMap.get(fdesc);
                        }
                        flist.add(fgi);
                        Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo DEBUG - adding FruGuiInfo:" + fgi);
                    }
                }
                this.fruInfoByEnclosure.put(enclosureMTMS, returnMap);
            } else {
                Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo locations map=null for enclosure MTMS[" + enclosureMTMS + "]");
            }
        } else {
            Trace.trace(TRACE_MASKD, "FruConfig.queryEnclosureFruInfo enclosure MTMS[" + enclosureMTMS + "] previously parsed by this instance");
        }
        return (Map)this.fruInfoByEnclosure.get(enclosureMTMS);
    }

    public Collection queryAllowableEnclosures() throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        if (this.completeFruTable == null) {
            this.completeFruTable = FruConfig.getFruMap(this.systemType, this.systemModel);
        }
        return Collections.unmodifiableCollection(this.completeFruTable.values());
    }

    public LocalizableText[] queryLocalizableDescriptionsByLocation(String[] locations, String[] ids) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        LocalizableText[] descriptions = new LocalizableText[locations.length];
        for (int aii = 0; aii < locations.length; ++aii) {
            String location = locations[aii].trim();
            if (location.indexOf(45) == -1) {
                String testKey;
                EnclosureConfigEntry ece;
                if (this.completeFruTable == null) {
                    this.completeFruTable = FruConfig.getFruMap(this.systemType, this.systemModel);
                }
                if ((ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey = FruConfig.makeTypeModelEnclosureKey(location))) != null) {
                    descriptions[aii] = ece.getLocalizableDesc();
                    continue;
                }
                Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation key[" + testKey + "] not found in enclosure map for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                testKey = FruConfig.makeFeatureCodeEnclosureKey(location);
                ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey);
                if (ece == null) {
                    Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation key[" + testKey + "] not found in enclosure map for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                    descriptions[aii] = null;
                    continue;
                }
                descriptions[aii] = ece.getLocalizableDesc();
                continue;
            }
            String enclosureMTMS = location.substring(0, location.indexOf(45));
            String suffix = location.substring(location.indexOf(45) + 1);
            Map enclosureMap = this.queryEnclosureFruInfo(enclosureMTMS);
            Collection values = enclosureMap.values();
            Iterator it = values.iterator();
            boolean found = false;
            FruGuiInfo defaultFgi = null;
            while (!found && it.hasNext()) {
                List fgl = (List)it.next();
                if (fgl == null) continue;
                Iterator fgli = fgl.iterator();
                while (!found && fgli.hasNext()) {
                    FruGuiInfo fgi = (FruGuiInfo)fgli.next();
                    if (!fgi.getLocationSuffix().equals(suffix)) continue;
                    if (defaultFgi == null && fgi.getId() == null) {
                        defaultFgi = fgi;
                    }
                    if (ids == null || ids[aii] == null || fgi.getId() == null || !ids[aii].toUpperCase().equals(fgi.getId().toUpperCase())) continue;
                    descriptions[aii] = fgi.getLocalizableDesc();
                    found = true;
                }
            }
            if (found) continue;
            if (defaultFgi != null) {
                descriptions[aii] = defaultFgi.getLocalizableDesc();
                continue;
            }
            Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation suffix[" + suffix + "] not found in enclosure [" + enclosureMTMS + "]");
            descriptions[aii] = new LocalizableText("unknown");
        }
        return descriptions;
    }

    public Object[] queryInfoByLocation(String[] locations, String[] ids) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        Object[] infoArray = new Object[locations.length];
        for (int aii = 0; aii < locations.length; ++aii) {
            if (locations[aii].indexOf(45) == -1) {
                if (this.completeFruTable == null) {
                    this.completeFruTable = FruConfig.getFruMap(this.systemType, this.systemModel);
                }
                String testKey = FruConfig.makeTypeModelEnclosureKey(locations[aii]);
                EnclosureConfigEntry ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey);
                Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation key[" + testKey + "] not found in enclosure map for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                if (ece != null) continue;
                testKey = FruConfig.makeFeatureCodeEnclosureKey(locations[aii]);
                ece = (EnclosureConfigEntry)this.completeFruTable.get(testKey);
                infoArray[aii] = ece;
                if (ece != null) continue;
                Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation key[" + testKey + "] not found in enclosure map for managed system type[" + this.systemType + "],model[" + this.systemModel + "]");
                continue;
            }
            String enclosureMTMS = locations[aii].substring(0, locations[aii].indexOf(45));
            String suffix = locations[aii].substring(locations[aii].indexOf(45) + 1);
            Map enclosureMap = this.queryEnclosureFruInfo(enclosureMTMS);
            Collection values = enclosureMap.values();
            Iterator it = values.iterator();
            boolean found = false;
            FruGuiInfo defaultFgi = null;
            while (!found && it.hasNext()) {
                List fgl = (List)it.next();
                if (fgl == null) continue;
                Iterator fgli = fgl.iterator();
                while (!found && fgli.hasNext()) {
                    FruGuiInfo fgi = (FruGuiInfo)fgli.next();
                    if (!fgi.getLocationSuffix().equals(suffix)) continue;
                    if (defaultFgi == null && fgi.getId() == null) {
                        defaultFgi = fgi;
                    }
                    if (ids == null || ids[aii] == null || fgi.getId() == null || !ids[aii].toUpperCase().equals(fgi.getId().toUpperCase())) continue;
                    infoArray[aii] = fgi;
                    found = true;
                }
            }
            if (found) continue;
            if (defaultFgi != null) {
                infoArray[aii] = defaultFgi;
                continue;
            }
            Trace.trace(TRACE_MASKD, "FruConfig.queryLocalizableDescriptionsByLocation suffix[" + suffix + "] not found in enclosure [" + enclosureMTMS + "]");
            infoArray[aii] = null;
        }
        return infoArray;
    }

    public String[] queryDescriptionsByLocation(String[] locations, String[] ids) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        LocalizableText[] descriptions = this.queryLocalizableDescriptionsByLocation(locations, ids);
        String[] sdescs = new String[descriptions.length];
        for (int aii = 0; aii < descriptions.length; ++aii) {
            sdescs[aii] = descriptions[aii] == null ? "" : descriptions[aii].toString();
        }
        return sdescs;
    }

    private static String makeTypeModelEnclosureKey(String mtms) {
        String model;
        String type;
        mtms.trim().toUpperCase();
        if (mtms.startsWith("U")) {
            int firstdot = mtms.indexOf(46, 1);
            if (firstdot == -1) {
                return mtms;
            }
            int nextdot = mtms.indexOf(46, firstdot + 1);
            type = mtms.substring(1, firstdot);
            model = nextdot == -1 ? mtms.substring(firstdot + 1) : mtms.substring(firstdot + 1, nextdot);
        } else {
            int dash = mtms.indexOf(45);
            if (dash == -1) {
                return mtms;
            }
            int star = mtms.indexOf(42);
            if (star == -1) {
                star = mtms.indexOf(47);
            }
            type = mtms.substring(0, dash);
            model = star == -1 ? mtms.substring(dash + 1) : mtms.substring(dash + 1, star);
        }
        return type + "|" + model;
    }

    private static String makeFeatureCodeEnclosureKey(String mtms) {
        String type;
        mtms.trim().toUpperCase();
        if (mtms.startsWith("U")) {
            int firstdot = mtms.indexOf(46, 1);
            if (firstdot == -1) {
                return mtms + "|" + "FEATURE_CODE";
            }
            type = mtms.substring(1, firstdot);
        } else {
            int dash = mtms.indexOf(45);
            if (dash == -1) {
                return mtms + "|" + "FEATURE_CODE";
            }
            type = mtms.substring(0, dash);
        }
        return type + "|" + "FEATURE_CODE";
    }

    public String[] queryAllowableLocations(String enclosureMTMS, String fruDesc) throws SAXNotRecognizedException, SAXNotSupportedException, HException {
        String sEC = "\n<<<< ----- >>>>\n";
        String sEnclParmFormat = "Utttt.mmm.sssssss";
        Trace.trace(TRACE_MASKT, "-> FruConfig.queryAllowableLocations: enclosure[" + enclosureMTMS + "], desc[" + fruDesc + "]");
        Trace.trace(TRACE_MASKF, "-> FruConfig.queryAllowableLocations: enclosure[" + enclosureMTMS + "], desc[" + fruDesc + "]");
        if (enclosureMTMS == null || enclosureMTMS.length() < sEnclParmFormat.length()) {
            Trace.trace(TRACE_MASKF, "Bad input parameter: enclosureMTMS.");
        }
        if (fruDesc == null) {
            Trace.trace(TRACE_MASKF, "Bad input parameter: fruDesc.");
        }
        if (enclosureMTMS == null || enclosureMTMS.length() < sEnclParmFormat.length() || fruDesc == null) {
            Trace.trace(TRACE_MASKT, "<- FruConfig.queryAllowableLocations - bad input parm ,returning 'unknown'");
            return new String[]{"unknown"};
        }
        HashMap hmFruInfo = (HashMap)this.queryEnclosureFruInfo(enclosureMTMS);
        String[] saLocations = null;
        if (hmFruInfo == null) {
            saLocations = new String[]{"unknown"};
        } else {
            Trace.trace(TRACE_MASKD, sEC + "hmFruInfo = " + hmFruInfo.toString());
            ArrayList<String> alLocations = new ArrayList<String>(100);
            Set descSet = hmFruInfo.entrySet();
            Iterator descIt = descSet.iterator();
            while (descIt.hasNext()) {
                Map.Entry descEntry = descIt.next();
                String sDescInMap = (String)descEntry.getKey();
                Trace.trace(TRACE_MASKD, "FruConfig.queryAllowableLocations sDescInMap = >>>" + sDescInMap + "<<<");
                if (!sDescInMap.equals(fruDesc)) continue;
                Trace.trace(TRACE_MASKD, "FruConfig.queryAllowableLocations MATCH!");
                List fruInfo = (List)descEntry.getValue();
                Iterator it = fruInfo.iterator();
                while (it.hasNext()) {
                    FruGuiInfo fgi = (FruGuiInfo)it.next();
                    Trace.trace(TRACE_MASKD, "FruConfig.queryAllowableLocations adding allowable location suffix: " + fgi.getLocationSuffix());
                    alLocations.add(fgi.getLocationSuffix());
                }
                break block0;
            }
            if (alLocations.size() == 0) {
                saLocations = new String[]{"unknown"};
            } else {
                saLocations = new String[alLocations.size()];
                for (int i = 0; i < alLocations.size(); ++i) {
                    saLocations[i] = (String)alLocations.get(i);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- FruConfig.queryAllowableLocations");
        return saLocations;
    }
}

